/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.slabmachines.blocks;

import com.mrbysco.slabmachines.blocks.base.CustomSlabBlock;
import com.mrbysco.slabmachines.entity.TNTSlabEntity;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class TNTSlabBlock
extends CustomSlabBlock {
    public static final BooleanProperty UNSTABLE = BlockStateProperties.f_61361_;
    public static final BooleanProperty ETHOSLAB = BooleanProperty.m_61465_((String)"etho");

    public TNTSlabBlock(BlockBehaviour.Properties properties) {
        super(properties.m_60966_().m_60918_(SoundType.f_56740_));
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)UNSTABLE, (Comparable)Boolean.valueOf(false))).m_61124_((Property)ETHOSLAB, (Comparable)Boolean.valueOf(false)));
    }

    public void catchFire(BlockState state, Level world, BlockPos pos, @Nullable Direction face, @Nullable LivingEntity igniter) {
        this.explode(world, pos, igniter);
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        ItemStack stack = context.m_43722_();
        return (BlockState)super.m_5573_(context).m_61124_((Property)ETHOSLAB, (Comparable)Boolean.valueOf(stack.m_41786_().m_6111_().equalsIgnoreCase("Etho slab")));
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!oldState.m_60713_(state.m_60734_()) && level.m_46753_(pos)) {
            this.catchFire(state, level, pos, null, null);
            level.m_7471_(pos, false);
        }
    }

    public boolean isEthoSlab(Level level, BlockPos pos) {
        BlockState partState = level.m_8055_(pos);
        boolean etho = false;
        if (partState.m_61147_().contains(ETHOSLAB)) {
            etho = (Boolean)partState.m_61143_((Property)ETHOSLAB);
        }
        return etho;
    }

    public void m_7592_(Level level, BlockPos pos, Explosion explosionIn) {
        if (!level.f_46443_) {
            TNTSlabEntity tntentity = new TNTSlabEntity(level, (double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5, explosionIn.m_46079_(), this.isEthoSlab(level, pos));
            tntentity.m_32085_((short)(level.f_46441_.nextInt(tntentity.m_32100_() / 4) + tntentity.m_32100_() / 8));
            level.m_7967_((Entity)tntentity);
        }
    }

    public void explode(Level level, BlockPos pos, LivingEntity igniter) {
        if (!level.f_46443_) {
            TNTSlabEntity tntentity = new TNTSlabEntity(level, (double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5, igniter, this.isEthoSlab(level, pos));
            level.m_7967_((Entity)tntentity);
            level.m_6263_((Player)null, tntentity.m_20185_(), tntentity.m_20186_(), tntentity.m_20189_(), SoundEvents.f_12512_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> blockStateBuilder) {
        blockStateBuilder.m_61104_(new Property[]{TYPE, WATERLOGGED, UNSTABLE, ETHOSLAB});
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        ItemStack itemstack = player.m_21120_(handIn);
        Item item = itemstack.m_41720_();
        if (item != Items.f_42409_ && item != Items.f_42613_) {
            return super.m_6227_(state, level, pos, player, handIn, hit);
        }
        this.catchFire(state, level, pos, hit.m_82434_(), (LivingEntity)player);
        level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 11);
        if (!player.m_7500_()) {
            if (item == Items.f_42409_) {
                itemstack.m_41622_(1, (LivingEntity)player, player1 -> player1.m_21190_(handIn));
            } else {
                itemstack.m_41774_(1);
            }
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public void m_5581_(Level level, BlockState state, BlockHitResult hit, Projectile projectile) {
        if (!level.f_46443_) {
            Entity entity = projectile.m_37282_();
            if (projectile.m_6060_()) {
                BlockPos blockpos = hit.m_82425_();
                this.catchFire(state, level, blockpos, null, entity instanceof LivingEntity ? (LivingEntity)entity : null);
                level.m_7471_(blockpos, false);
            }
        }
    }

    public boolean m_6903_(Explosion explosionIn) {
        return false;
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (level.m_46753_(pos)) {
            this.catchFire(state, level, pos, null, null);
            level.m_7471_(pos, false);
        }
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }
}

